/*
 * Decompiled with CFR 0.152.
 */
package kz.ecc.nursign.common;

import java.security.Provider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.smartcardio.CardException;
import kz.ecc.nursign.exceptions.NURSignException;
import kz.ecc.nursign.gui.util.GUITools;
import kz.ecc.nursign.model.KeyEntry;
import kz.ecc.nursign.model.TokenDetail;
import kz.ecc.nursign.osgi.BundleLog;
import kz.ecc.nursign.osgi.BundleProvider;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.exception.ProviderUtilExceptionCode;
import kz.gov.pki.provider.utils.KeyStoreUtil;
import kz.gov.pki.reference.KeyStoreEntry;

public class ServiceSource {
    private static final List<TokenDetail> tokens = new ArrayList<TokenDetail>();
    private static final Set<KeyEntry> entries = new HashSet<KeyEntry>();

    private static void init() {
        ServiceSource.checkTokens();
    }

    private static void checkTokens() {
        BundleLog.LOG.info("check existing tokens");
        ArrayList existsStorages = new ArrayList();
        entries.stream().filter(entry -> entry.getStorage().isToken()).forEach(entry -> {
            if (!existsStorages.contains(entry.getStorage())) {
                existsStorages.add(entry.getStorage());
            }
        });
        tokens.clear();
        for (Storage storage : Storage.values()) {
            if (!storage.isToken() || existsStorages.contains(storage)) continue;
            try {
                List slotList = KeyStoreUtil.loadSlotList((Storage)storage);
                if (slotList.size() <= 0) continue;
                slotList.forEach(terminalName -> tokens.add(new TokenDetail(storage, (String)terminalName)));
            }
            catch (CardException e) {
                BundleLog.LOG.info("On check storage error ->>>>>> " + e.getMessage());
            }
            catch (KalkanException | ProviderUtilException e) {
                BundleLog.LOG.error("LoadSlotList error", e);
            }
        }
        tokens.add(ServiceSource.getPKCS12Token());
        BundleLog.LOG.info("tokens COUNT = " + tokens.size());
    }

    private static TokenDetail getPKCS12Token() {
        return new TokenDetail(Storage.PKCS12, GUITools.getResourceBundle().getString("form.main_dialog.select_certificate"));
    }

    public static KeyEntry getPKCS12KeyEntry(TokenDetail tokenDetail, char[] pass) throws NURSignException {
        KeyEntry result = null;
        try {
            Map keyStoreEntryMap = KeyStoreUtil.getKeyStoreEntries((Storage)tokenDetail.getStorage(), (String)tokenDetail.getEntryName(), null, (char[])pass, (Provider)BundleProvider.KALKANCRYPT.getProvider());
            String alies = (String)keyStoreEntryMap.keySet().iterator().next();
            result = new KeyEntry((KeyStoreEntry)keyStoreEntryMap.get(alies), tokenDetail);
            entries.add(result);
            ServiceSource.setCurrentKeyEntry(result);
        }
        catch (ProviderUtilException e) {
            if (e.getCode().equals((Object)ProviderUtilExceptionCode.WRONG_KEYSTORE_PASSWORD)) {
                throw new NURSignException(NURSignException.ExceptionTypes.WRONG_PASSWORD);
            }
        }
        catch (Exception e) {
            BundleLog.LOG.error("Extract keys error", e);
            result = null;
        }
        ServiceSource.checkTokens();
        return result;
    }

    public static List<KeyEntry> parseTokenStorage(TokenDetail tokenDetail, char[] pass) throws NURSignException {
        try {
            ArrayList<KeyEntry> entryList = new ArrayList<KeyEntry>(2);
            Map keyStoryEntries = KeyStoreUtil.getKeyStoreEntries((Storage)tokenDetail.getStorage(), (String)tokenDetail.getEntryName(), null, (char[])pass, (Provider)BundleProvider.KALKANCRYPT.getProvider());
            boolean isCurrent = keyStoryEntries.values().size() == 1;
            for (KeyStoreEntry keyStoreEntry : keyStoryEntries.values()) {
                KeyEntry keyEntry = new KeyEntry(keyStoreEntry, tokenDetail);
                entries.add(keyEntry);
                entryList.add(keyEntry);
                if (!isCurrent && !keyEntry.getAlgorithm().equals("RSA")) continue;
                ServiceSource.setCurrentKeyEntry(keyEntry);
            }
            ServiceSource.checkTokens();
            return entryList;
        }
        catch (ProviderUtilException e) {
            if (e.getCode().equals((Object)ProviderUtilExceptionCode.WRONG_KEYSTORE_PASSWORD)) {
                throw new NURSignException(NURSignException.ExceptionTypes.WRONG_PASSWORD);
            }
            throw new NURSignException(NURSignException.ExceptionTypes.CERTIFICATE_PARSING_ERROR);
        }
        catch (Exception e) {
            BundleLog.LOG.error("parse token error", e);
            throw new NURSignException(NURSignException.ExceptionTypes.CERTIFICATE_PARSING_ERROR);
        }
    }

    public static void setCurrentKeyEntry(KeyEntry keyEntry) {
        entries.forEach(e -> {
            if (e.equals((Object)keyEntry)) {
                e.setCurrent(true);
            } else {
                e.setCurrent(false);
            }
        });
        BundleLog.LOG.debug("selected keyEntry is: ");
        BundleLog.LOG.debug(keyEntry.toString());
    }

    public static KeyEntry getSelectedKeyEntry() {
        for (KeyEntry keyEntry : entries) {
            if (!keyEntry.isCurrent()) continue;
            return keyEntry;
        }
        return null;
    }

    public static void removeKeyEntry(KeyEntry keyEntry) {
        entries.remove((Object)keyEntry);
    }

    public static void addKeyEntry(KeyEntry keyEntry) {
        entries.add(keyEntry);
    }

    public static List<TokenDetail> getTokens() {
        BundleLog.LOG.info("get tokens");
        return tokens;
    }

    public static void removeToken(TokenDetail tokenDetail) {
        tokens.remove(tokenDetail);
    }

    public static Set<KeyEntry> getKeyEntries() {
        return entries;
    }

    static {
        BundleLog.LOG.info("Init ServiceStorage");
        ServiceSource.init();
    }
}

