/*
 * Decompiled with CFR 0.152.
 */
package kz.ecc.nursign.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import kz.ecc.nursign.gui.util.GUIUtilities;

public class DownLoadDialog
extends JDialog {
    private ResourceBundle bundle;
    private JProgressBar progressBar;
    private Boolean finish;
    private STATUS status = STATUS.DOWNLOADING;

    public DownLoadDialog(ResourceBundle bundle) {
        this.bundle = bundle;
        this.init();
    }

    private void init() {
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setTitle(this.bundle.getString("dialog.download.title"));
        this.setDefaultCloseOperation(1);
        this.setFocusable(true);
        this.setResizable(false);
        this.initComponents();
    }

    private void initComponents() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DownLoadDialog.this.doCancel();
                System.out.println("closing");
            }

            @Override
            public void windowClosed(WindowEvent e) {
                System.out.println("closed");
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setBackground(GUIUtilities.FORM_COLOR);
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.createMainPanel(), "Center");
        contentPane.add((Component)this.createButtonPanel(), "South");
        this.pack();
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        JButton cancelButton = new JButton(this.bundle.getString("button.cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownLoadDialog.this.doCancel();
            }
        });
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel.setOpaque(false);
        panel.add(Box.createHorizontalGlue());
        panel.add(cancelButton);
        return panel;
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        mainPanel.add(this.progressBar);
        return mainPanel;
    }

    private void doCancel() {
        this.status = STATUS.CANCELED;
    }

    public STATUS getStatus() {
        return this.status;
    }

    public void next(int i) {
        this.progressBar.setValue(i);
    }

    public void startDownload(int max) {
        this.finish = false;
        this.status = STATUS.DOWNLOADING;
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(max);
        this.progressBar.setValue(0);
        Timer timer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                if (!DownLoadDialog.this.isFinish().booleanValue()) {
                    DownLoadDialog.this.showDialog();
                }
            }
        };
        timer.schedule(timerTask, 2000L);
    }

    public synchronized void setFinish(Boolean f) {
        this.finish = f;
    }

    private synchronized Boolean isFinish() {
        return this.finish;
    }

    public void showDialog() {
        this.setVisible(true);
        this.setAlwaysOnTop(true);
    }

    public void hideDialog() {
        this.setVisible(false);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    public static enum STATUS {
        DOWNLOADING,
        DOWNLOADED,
        CANCELED,
        ERROR;

    }
}

