/*
 * Decompiled with CFR 0.152.
 */
package kz.ecc.nursign.gui;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import kz.ecc.nursign.common.ServiceSource;
import kz.ecc.nursign.exceptions.NURSignException;
import kz.ecc.nursign.gui.GUIFabric;
import kz.ecc.nursign.gui.MessageDialog;
import kz.ecc.nursign.gui.PasswordDialog;
import kz.ecc.nursign.gui.SelectContainerDialog;
import kz.ecc.nursign.gui.components.TButton;
import kz.ecc.nursign.gui.filechooser.FileChooser;
import kz.ecc.nursign.gui.filechooser.FileChooserDialog;
import kz.ecc.nursign.gui.util.GUITools;
import kz.ecc.nursign.gui.util.GUIUtilities;
import kz.ecc.nursign.model.KeyEntry;
import kz.ecc.nursign.model.TokenDetail;
import kz.ecc.nursign.osgi.BundleLog;
import kz.gov.pki.kalkan.Storage;

public class MainDialog
extends JDialog {
    private static final int WIDTH = 375;
    private static final int HEIGHT = 220;
    private final ResourceBundle resourceBundle;
    private JPanel keyEntriesPanel;
    private JPanel tokensPanel;
    private String password = null;
    private final List<TokenDetail> tokenDetailList;
    private Set<KeyEntry> keyEntries;
    private boolean sign = false;

    public MainDialog(ResourceBundle resourceBundle, List<TokenDetail> tokenDetailList, Set<KeyEntry> keyEntries) {
        this.resourceBundle = resourceBundle;
        this.tokenDetailList = tokenDetailList;
        this.keyEntries = keyEntries;
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setFocusable(true);
        this.setTitle(resourceBundle.getString("form.main_dialog.title"));
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setBackground(Color.white);
        this.setFrameToScreenCenter();
        this.initComponents();
        BundleLog.LOG.debug("CREATED DIALOG");
        this.setVisible(true);
    }

    private void initComponents() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.setBackground(GUIUtilities.FORM_COLOR);
        mainPanel.add(this.createMainPanel());
        this.getContentPane().add(mainPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainDialog.this.setVisible(false);
                MainDialog.this.dispose();
            }
        });
        this.pack();
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.keyEntriesPanel = this.createPanel();
        this.tokensPanel = this.createPanel();
        mainPanel.add(this.keyEntriesPanel);
        mainPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        mainPanel.add(this.tokensPanel);
        mainPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        return mainPanel;
    }

    private JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setBackground(GUIUtilities.FORM_COLOR);
        GridLayout gridLayout = new GridLayout(0, 1, 5, 3);
        panel.setLayout(gridLayout);
        return panel;
    }

    private void fillContentPanel() {
        this.fillKeyEntriesPanel();
        this.fillTokensPanel();
    }

    public boolean isSign() {
        return this.sign;
    }

    public char[] getPassword() {
        String pass;
        if (this.password != null && !this.password.isEmpty()) {
            return this.password.toCharArray();
        }
        PasswordDialog passDialog = new PasswordDialog((Dialog)this, this.resourceBundle, ServiceSource.getSelectedKeyEntry().toString());
        passDialog.setVisible(true);
        if (passDialog.isOk() && (pass = passDialog.getPassword()) != null && !pass.isEmpty()) {
            return pass.toCharArray();
        }
        return null;
    }

    private void fillKeyEntriesPanel() {
        this.keyEntriesPanel.removeAll();
        for (KeyEntry keyEntry : this.keyEntries) {
            Color color;
            switch (keyEntry.getCertType()) {
                case "A": {
                    color = GUIUtilities.AUTHENTICATE;
                    break;
                }
                case "S": {
                    color = GUIUtilities.SIGNATURE;
                    break;
                }
                case "SA": {
                    color = GUIUtilities.AUTH_AND_SIGN;
                    break;
                }
                default: {
                    color = GUIUtilities.DEF;
                }
            }
            TButton keyEntryButton = new TButton(keyEntry.toButtonText() + "<br/><i style='font:50%'>" + keyEntry.getTypeDescription() + " - " + this.resourceBundle.getString(keyEntry.getStorage().getName()) + "</i>", color);
            JMenuItem menuItem = new JMenuItem(this.resourceBundle.getString("popupmenu.delete_certificate"));
            menuItem.addActionListener(e -> {
                ServiceSource.removeKeyEntry(keyEntry);
                this.fillKeyEntriesPanel();
            });
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add(menuItem);
            PopupListener mouseListener = new PopupListener(popupMenu);
            keyEntryButton.addMouseListener(mouseListener);
            keyEntryButton.setFocusPainted(true);
            keyEntryButton.setMargin(new Insets(5, 3, 5, 3));
            keyEntryButton.setBorderPainted(true);
            keyEntryButton.setToolTipText(keyEntry.getTooltip());
            keyEntryButton.addActionListener(e -> {
                ServiceSource.setCurrentKeyEntry(keyEntry);
                this.sign = true;
                this.setVisible(false);
            });
            this.keyEntriesPanel.add(keyEntryButton);
        }
        this.pack();
    }

    private void fillTokensPanel() {
        this.tokensPanel.removeAll();
        for (TokenDetail tokenDetail : this.tokenDetailList) {
            TButton tokenButton = new TButton(tokenDetail.toString());
            tokenButton.setBackground(GUIUtilities.BUTTON_COLOR);
            tokenButton.setMargin(new Insets(5, 5, 5, 0));
            tokenButton.addActionListener(al -> this.showChooseTokenDialog(tokenDetail));
            this.tokensPanel.add(tokenButton);
        }
        this.pack();
    }

    private void showChooseTokenDialog(TokenDetail tokenDetail) {
        if (tokenDetail.getStorage() == Storage.PKCS12) {
            FileChooserDialog fileChooserDialog = new FileChooserDialog(new JFrame(), FileChooser.FileType.P12, "", this.resourceBundle.getString("form.main_dialog.select_certificate"));
            String path = fileChooserDialog.getSelectedFilePath();
            tokenDetail.setEntryName(path);
        }
        if (tokenDetail.getEntryName() != null) {
            PasswordDialog passDialog = new PasswordDialog((Dialog)this, this.resourceBundle, tokenDetail.getName());
            passDialog.setVisible(true);
            if (passDialog.isOk()) {
                String passString = passDialog.getPassword();
                try {
                    List<KeyEntry> entries = ServiceSource.parseTokenStorage(tokenDetail, passString.toCharArray());
                    if (entries.size() > 0) {
                        KeyEntry selected = null;
                        if (entries.size() > 1) {
                            SelectContainerDialog dialog = GUIFabric.getSelectContainerDialog();
                            dialog.setDialogTitle("dialog.choose_container.title");
                            dialog.setValues(entries);
                            dialog.setVisible(true);
                            selected = (KeyEntry)((Object)dialog.getSelectedValue());
                        } else {
                            selected = entries.get(0);
                        }
                        if (selected != null) {
                            ServiceSource.setCurrentKeyEntry(selected);
                            this.password = passString;
                            this.sign = true;
                            this.setVisible(false);
                        }
                    }
                }
                catch (NURSignException e) {
                    MessageDialog messageDialog = GUIFabric.showErrorMessage();
                    messageDialog.showMessage(GUITools.getResourceBundle().getString(e.getExceptionTypes().name()));
                }
            }
        }
    }

    private void setFrameToScreenCenter() {
        Dimension d = this.getToolkit().getScreenSize();
        this.setLocation(d.width / 2 - this.getWidth() / 2, d.height / 2 - this.getHeight() / 2);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.sign = false;
            this.fillContentPanel();
        }
        super.setVisible(b);
    }

    class PopupListener
    extends MouseAdapter {
        private JPopupMenu popupMenu;

        public PopupListener(JPopupMenu popupMenu) {
            this.popupMenu = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
        }

        private void showPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

