/*
 * Decompiled with CFR 0.152.
 */
package kz.ecc.nursign.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import kz.ecc.nursign.gui.BoxLayoutUtil;
import kz.ecc.nursign.gui.util.GUITools;

public class MessageDialog
extends JDialog {
    public static final int ERROR_MESSAGE = 0;
    public static final int WARNING = 1;
    public static final int INFORMATION = 2;
    private JLabel messageText;
    private ResourceBundle bundle;
    private JPanel panel = new JPanel();

    public MessageDialog(ResourceBundle bundle) {
        this.bundle = bundle;
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setLocationRelativeTo(null);
        this.setFocusable(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        Container container = this.getContentPane();
        container.setBackground(Color.WHITE);
        container.setLayout(new BorderLayout());
        this.panel.setBorder(GUITools.createTitleBorder(bundle.getString("joption.pane.title")));
        this.panel.setBackground(Color.WHITE);
        container.add((Component)this.panel, "Center");
        container.add((Component)this.createButtonPanel(), "South");
        this.panel.setLayout(new BoxLayout(this.panel, 1));
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = BoxLayoutUtil.createHorizontalPanel();
        buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        buttonPanel.add(Box.createHorizontalGlue());
        JButton closeButton = new JButton(this.bundle.getString("form.button.close_button"));
        buttonPanel.add(closeButton);
        closeButton.addActionListener(e -> this.setVisible(false));
        return buttonPanel;
    }

    public void setMessageType(int messageType) {
        String title;
        switch (messageType) {
            case 0: {
                title = this.bundle.getString("joption.pane.title");
                break;
            }
            case 1: {
                title = this.bundle.getString("joption.pane.attention");
                break;
            }
            case 2: {
                title = this.bundle.getString("joption.pane.attention");
                break;
            }
            default: {
                title = this.bundle.getString("joption.pane.attention");
            }
        }
        this.setTitle(title);
    }

    public void showMessage(String message) {
        this.messageText = new JLabel(message);
        this.panel.removeAll();
        this.panel.add(this.messageText);
        this.setFrameToScreenCenter();
        this.pack();
        this.setVisible(true);
    }

    private void setFrameToScreenCenter() {
        Dimension d = this.getToolkit().getScreenSize();
        this.setLocation(d.width / 2 - this.getWidth() / 2, d.height / 2 - this.getHeight() / 2);
    }
}

