/*
 * Decompiled with CFR 0.152.
 */
package kz.ecc.nursign.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.EmptyBorder;
import kz.ecc.nursign.gui.util.GUITools;

public class PasswordDialog
extends JDialog {
    private ResourceBundle bundle;
    private String tokenName;
    private JPasswordField passwordField;
    private JLabel tokenNameLabel;
    private JButton okButton;
    private JButton cancelButton;
    private boolean okPressed = false;
    private static final int WIDTH = 375;
    private static final int HEIGHT = 145;

    public PasswordDialog(Frame frame, String tokenName) {
        super(frame);
        this.init(GUITools.getResourceBundle(), tokenName);
    }

    public PasswordDialog(Dialog owner, ResourceBundle bundle, String tokenName) {
        super(owner);
        this.init(bundle, tokenName);
    }

    private void init(ResourceBundle bundle, String tokenName) {
        this.bundle = bundle;
        this.tokenName = tokenName;
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setFocusable(true);
        this.setTitle(bundle.getString("form.main_dialog.enter_password"));
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setSize(new Dimension(375, 145));
        this.setPreferredSize(new Dimension(375, 145));
        this.setBackground(Color.white);
        this.setFrameToScreenCenter();
        this.initComponents();
    }

    private void initComponents() {
        Container mainContainer = this.getContentPane();
        mainContainer.setBackground(Color.WHITE);
        mainContainer.setLayout(new BorderLayout());
        JPanel centralPanel = GUITools.createPanelWithBorder();
        centralPanel.setLayout(new BoxLayout(centralPanel, 1));
        JPanel labelPanel = new JPanel();
        this.tokenNameLabel = new JLabel(this.tokenName);
        labelPanel.add(this.tokenNameLabel);
        centralPanel.add(labelPanel);
        this.passwordField = new JPasswordField();
        this.passwordField.setFocusable(true);
        this.passwordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PasswordDialog.this.okButtonActionPerformed();
                }
                if (e.getKeyCode() == 27) {
                    PasswordDialog.this.passwordField.setText("");
                    PasswordDialog.this.cancelButtonActionPerformed();
                }
            }
        });
        centralPanel.add(GUITools.createPasswordPanel(this.passwordField));
        centralPanel.add(Box.createVerticalGlue());
        mainContainer.add((Component)centralPanel, "Center");
        JPanel buttonPanel = GUITools.createPanelWithBorder();
        buttonPanel.setLayout(new BorderLayout());
        JPanel westButtonPanel = new JPanel();
        westButtonPanel.setLayout(new GridLayout(1, 2, 5, 0));
        westButtonPanel.setBorder(new EmptyBorder(5, 3, 3, 3));
        this.okButton = new JButton(this.bundle.getString("form.ok_button"));
        this.okButton.addActionListener(e -> this.okButtonActionPerformed());
        this.cancelButton = new JButton(this.bundle.getString("form.cancel_button"));
        this.cancelButton.addActionListener(e -> this.cancelButtonActionPerformed());
        westButtonPanel.add(this.okButton);
        westButtonPanel.add(this.cancelButton);
        buttonPanel.add((Component)westButtonPanel, "West");
        mainContainer.add((Component)buttonPanel, "South");
        this.pack();
        this.passwordField.requestFocus();
    }

    private void okButtonActionPerformed() {
        this.okPressed = true;
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed() {
        this.okPressed = false;
        this.setVisible(false);
        this.dispose();
    }

    public boolean isOk() {
        return this.okPressed;
    }

    public String getPassword() {
        return new String(this.passwordField.getPassword());
    }

    private void setFrameToScreenCenter() {
        Dimension d = this.getToolkit().getScreenSize();
        this.setLocation(d.width / 2 - this.getWidth() / 2, d.height / 2 - this.getHeight() / 2);
    }
}

