/*
 * Decompiled with CFR 0.152.
 */
package kz.ecc.nursign.gui;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import kz.ecc.nursign.gui.components.TButton;
import kz.ecc.nursign.gui.util.GUIUtilities;

public class SelectContainerDialog
extends JDialog {
    private ResourceBundle bundle;
    private Object selectedValue;
    private JPanel containersPanel;
    private List<? extends Object> valueList;

    public SelectContainerDialog(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
        this.initComponents();
    }

    public void setDialogTitle(String title) {
        this.setTitle(this.bundle.getString(title));
    }

    private void initComponents() {
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setLocationRelativeTo(null);
        this.setFocusable(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.setBackground(GUIUtilities.FORM_COLOR);
        mainPanel.add(this.createContainersPanel());
        mainPanel.setBackground(GUIUtilities.FORM_COLOR);
        this.getContentPane().add(mainPanel);
        this.pack();
    }

    public void setValues(List<? extends Object> values) {
        this.valueList = values;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.selectedValue = null;
            this.refreshContainersPanel();
        }
        super.setVisible(b);
    }

    private void refreshContainersPanel() {
        this.containersPanel.removeAll();
        for (Object object : this.valueList) {
            TButton button = new TButton(object.toString());
            button.addActionListener(e -> {
                this.selectedValue = s;
                this.setVisible(false);
            });
            button.setFocusPainted(true);
            button.setMargin(new Insets(5, 3, 5, 3));
            button.setBorderPainted(true);
            this.containersPanel.add(button);
        }
        this.pack();
    }

    public Object getSelectedValue() {
        return this.selectedValue;
    }

    private JPanel createContainersPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new EmptyBorder(3, 3, 3, 3));
        panel.setBackground(GUIUtilities.FORM_COLOR);
        panel.add(this.createSelectContainerPanel());
        panel.add(Box.createRigidArea(new Dimension(0, 1)));
        TButton cancelButton = new TButton(this.bundle.getString("button.cancel"));
        cancelButton.setMargin(new Insets(5, 5, 5, 0));
        cancelButton.addActionListener(e -> {
            this.selectedValue = null;
            this.setVisible(false);
        });
        panel.add(cancelButton);
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
        return panel;
    }

    private JPanel createSelectContainerPanel() {
        this.containersPanel = new JPanel();
        this.containersPanel.setBackground(GUIUtilities.FORM_COLOR);
        this.containersPanel.setLayout(new GridLayout(0, 1, 5, 3));
        return this.containersPanel;
    }
}

