/*
 * Decompiled with CFR 0.152.
 */
package kz.ecc.nursign.gui.filechooser;

import java.awt.Color;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import kz.ecc.nursign.gui.filechooser.FileChooserFilter;
import kz.ecc.nursign.gui.util.GUITools;

public final class FileChooser
extends JFileChooser {
    private FileType currentFileType;
    private FileChooserFilter keyFilter = new FileChooserFilter();
    private ResourceBundle bundle = GUITools.getResourceBundle();

    public FileChooser(FileType fileType) {
        this.setFileType(fileType);
        this.setFileFilter(this.keyFilter);
        if (String.valueOf((Object)fileType).equalsIgnoreCase("ALL")) {
            this.removeChoosableFileFilter(this.getFileFilter());
        }
        this.setAcceptAllFileFilterUsed(false);
        this.setMultiSelectionEnabled(false);
        this.updateTitle();
        this.setBackground(Color.WHITE);
    }

    public FileChooser(String fileType) {
        if (fileType != null && !fileType.isEmpty()) {
            this.setFileType(FileType.valueOf(fileType));
        } else {
            this.setFileType(FileType.DIRECTORY);
        }
        this.setFileFilter(this.keyFilter);
        if (fileType.equalsIgnoreCase("ALL")) {
            this.removeChoosableFileFilter(this.getFileFilter());
        }
        this.setAcceptAllFileFilterUsed(false);
        this.setMultiSelectionEnabled(false);
        this.updateTitle();
    }

    public void setFileType(FileType fileType) {
        this.currentFileType = fileType;
        this.keyFilter.clearExtension();
        switch (fileType) {
            case DIRECTORY: {
                this.keyFilter.addExtension("");
                this.keyFilter.setDescription(this.bundle.getString("fileChooser.description.directory"));
                this.setFileSelectionMode(1);
                break;
            }
            case CER: {
                this.keyFilter.addExtension("der");
                this.keyFilter.addExtension("cer");
                this.keyFilter.setDescription(this.bundle.getString("fileChooser.description.cer"));
                this.setFileSelectionMode(0);
                break;
            }
            case CRL: {
                this.keyFilter.addExtension("crl");
                this.keyFilter.setDescription(this.bundle.getString("fileChooser.description.crl"));
                this.setFileSelectionMode(0);
                break;
            }
            case P12: {
                this.keyFilter.addExtension("p12");
                this.keyFilter.setDescription(this.bundle.getString("fileChooser.description.key"));
                this.setFileSelectionMode(0);
                break;
            }
            case JKS: {
                this.keyFilter.addExtension("jks");
                this.keyFilter.setDescription(this.bundle.getString("fileChooser.description.key"));
                this.setFileSelectionMode(0);
                break;
            }
            case KEYSTORE: {
                this.keyFilter.addExtension("pfx");
                this.keyFilter.addExtension("p12");
                this.keyFilter.addExtension("bin");
                this.keyFilter.addExtension("jks");
                this.keyFilter.setDescription(this.bundle.getString("fileChooser.description.key"));
                this.setFileSelectionMode(0);
                break;
            }
            case ALL: {
                this.keyFilter.addExtension("*");
                this.keyFilter.setDescription(this.bundle.getString("fileChooser.description.file"));
                this.setFileSelectionMode(0);
            }
        }
    }

    public void updateTitle() {
        switch (this.currentFileType) {
            case DIRECTORY: {
                this.setDialogTitle(" " + this.bundle.getString("fileChooser.title.directory"));
                break;
            }
            default: {
                this.setDialogTitle(" " + this.bundle.getString("fileChooser.title.file"));
            }
        }
        UIManager.put("FileChooser.openButtonText", this.bundle.getString("fileChooser.openButtonText"));
        UIManager.put("FileChooser.saveButtonText", this.bundle.getString("fileChooser.saveButtonText"));
        UIManager.put("FileChooser.cancelButtonText", this.bundle.getString("fileChooser.cancelButtonText"));
        UIManager.put("FileChooser.openButtonToolTipText", this.bundle.getString("fileChooser.openButtonToolTipText"));
        UIManager.put("FileChooser.saveButtonToolTipText", this.bundle.getString("fileChooser.saveButtonToolTipText"));
        UIManager.put("FileChooser.cancelButtonToolTipText", this.bundle.getString("fileChooser.cancelButtonToolTipText"));
        UIManager.put("FileChooser.lookInLabelText", this.bundle.getString("fileChooser.lookInLabelText"));
        UIManager.put("FileChooser.saveInLabelText", this.bundle.getString("fileChooser.saveInLabelText"));
        UIManager.put("FileChooser.fileNameLabelText", this.bundle.getString("fileChooser.fileNameLabelText"));
        UIManager.put("FileChooser.filesOfTypeLabelText", this.bundle.getString("fileChooser.filesOfTypeLabelText"));
        UIManager.put("FileChooser.upFolderToolTipText", this.bundle.getString("fileChooser.upFolderToolTipText"));
        UIManager.put("FileChooser.homeFolderToolTipText", this.bundle.getString("fileChooser.homeFolderToolTipText"));
        UIManager.put("FileChooser.newFolderToolTipText", this.bundle.getString("fileChooser.newFolderToolTipText"));
        UIManager.put("FileChooser.listViewButtonToolTipText", this.bundle.getString("fileChooser.listViewButtonToolTipText"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", this.bundle.getString("fileChooser.detailsViewButtonToolTipText"));
        UIManager.put("FileChooser.directoryOpenButtonText", this.bundle.getString("fileChooser.directoryOpenButtonText"));
        UIManager.put("FileChooser.directoryOpenButtonToolTipText", this.bundle.getString("fileChooser.directoryOpenButtonToolTipText"));
        this.updateDescription();
        this.updateUI();
    }

    public void updateDescription() {
        switch (this.currentFileType) {
            case DIRECTORY: {
                this.keyFilter.setDescription(this.bundle.getString("fileChooser.description.directory"));
                break;
            }
            case CER: {
                this.keyFilter.setDescription(this.bundle.getString("fileChooser.description.cer"));
                break;
            }
            case CRL: {
                this.keyFilter.setDescription(this.bundle.getString("fileChooser.description.crl"));
                break;
            }
            case P12: {
                this.keyFilter.setDescription(this.bundle.getString("fileChooser.description.key"));
                break;
            }
            case KEYSTORE: {
                this.keyFilter.setDescription(this.bundle.getString("fileChooser.description.key"));
                break;
            }
            case JKS: {
                this.keyFilter.setDescription(this.bundle.getString("fileChooser.description.key"));
                break;
            }
            default: {
                this.keyFilter.setDescription(this.bundle.getString("fileChooser.description.file"));
            }
        }
    }

    public static enum FileType {
        DIRECTORY,
        CRL,
        CER,
        P12,
        KEYSTORE,
        JKS,
        ALL;

    }
}

