/*
 * Decompiled with CFR 0.152.
 */
package kz.ecc.nursign.gui.filechooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import kz.ecc.nursign.gui.filechooser.FileChooser;

public class FileChooserDialog
extends JDialog {
    private String selectedFilePath = null;
    private FileChooser fileChooser = null;

    public FileChooserDialog(JDialog owner, FileChooser.FileType fileType, String currentDirectory, String title) {
        super(owner);
        this.init(fileType, currentDirectory, title);
    }

    public FileChooserDialog(JFrame owner, FileChooser.FileType fileType, String currentDirectory, String title) {
        super(owner);
        this.init(fileType, currentDirectory, title);
    }

    private void init(FileChooser.FileType fileType, String currentDirectory, String title) {
        this.setTitle(title);
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setBackground(Color.white);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int height = screenSize.height;
        int width = screenSize.width;
        this.setSize(width / 2, height / 2);
        this.setResizable(true);
        this.setLocationByPlatform(true);
        this.setLocationRelativeTo(null);
        this.fileChooser = new FileChooser(fileType);
        if (currentDirectory != null && !currentDirectory.isEmpty()) {
            this.fileChooser.setCurrentDirectory(new File(currentDirectory));
        }
        this.fileChooser.setDialogType(0);
        this.add(this.fileChooser);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                FileChooserDialog.this.dispose();
            }
        });
        this.pack();
        this.fileChooser.revalidate();
        this.fileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser choser = (JFileChooser)e.getSource();
                String str = e.getActionCommand();
                if (str.equals("ApproveSelection")) {
                    File selectedFile = choser.getSelectedFile();
                    if (selectedFile.exists()) {
                        FileChooserDialog.this.setSelectedFilePath(selectedFile.getPath());
                    }
                } else if (str.equals("CancelSelection")) {
                    FileChooserDialog.this.setSelectedFilePath(null);
                }
                FileChooserDialog.this.setVisible(false);
                FileChooserDialog.this.getOwner().dispose();
                FileChooserDialog.this.dispose();
            }
        });
        this.setVisible(true);
    }

    public void setSelectedFilePath(String selectedFilePath) {
        this.selectedFilePath = selectedFilePath;
    }

    public String getSelectedFilePath() {
        return this.selectedFilePath;
    }
}

