/*
 * Decompiled with CFR 0.152.
 */
package kz.ecc.nursign.gui.util;

import java.awt.GridLayout;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import kz.ecc.nursign.gui.util.UTF8Control;

public class GUITools {
    private static ResourceBundle resourceBundle;

    public static ResourceBundle getResourceBundle() {
        if (resourceBundle == null) {
            Locale locale = Locale.getDefault();
            resourceBundle = ResourceBundle.getBundle("Module", locale, new UTF8Control());
        }
        return resourceBundle;
    }

    public static JPanel createPanelWithBorder() {
        JPanel pannel = new JPanel();
        pannel.setBorder(new EmptyBorder(3, 3, 3, 3));
        return pannel;
    }

    public static JPanel createPasswordPanel(JPasswordField passwordField) {
        JPanel passPanel = GUITools.createPanelWithBorder();
        passPanel.setLayout(new GridLayout(1, 1, 3, 3));
        JPanel passwordPanel = new JPanel();
        passwordPanel.setLayout(new BoxLayout(passwordPanel, 0));
        JLabel passwordLabel = new JLabel(GUITools.getResourceBundle().getString("form.main_dialog.password"));
        passwordPanel.add(passwordLabel);
        passwordPanel.add(passwordField);
        passwordPanel.add(Box.createHorizontalGlue());
        passPanel.add(passwordPanel);
        return passPanel;
    }

    public static CompoundBorder createTitleBorder(String title) {
        return GUITools.createTitleBorder(title, 3, 3, 3, 3);
    }

    public static CompoundBorder createTitleBorder(String title, int top, int left, int bottom, int right) {
        return BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), title), BorderFactory.createEmptyBorder(top, left, bottom, right));
    }
}

