/*
 * Decompiled with CFR 0.152.
 */
package kz.ecc.nursign.helpers;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import kz.ecc.nursign.exceptions.NURSignException;
import kz.ecc.nursign.gui.DownLoadDialog;
import kz.ecc.nursign.gui.GUIFabric;
import kz.ecc.nursign.osgi.BundleLog;
import kz.ecc.nursign.utils.ConnectionUtil;

public class Downloader {
    private static final int BUFFER_SIZE = 2048;
    private URL url;
    private DownLoadDialog progressBarFrame;
    private DownLoadDialog.STATUS status;
    private int maxProgress;
    private HttpURLConnection con;
    private byte[] result;

    public Downloader(String url) throws IOException, NURSignException, NoSuchAlgorithmException, KeyManagementException {
        this.url = new URL(url);
        this.con = ConnectionUtil.getUrlConnection(this.url);
        this.progressBarFrame = GUIFabric.getDownLoadDialog();
        this.progressBarFrame.setVisible(false);
    }

    public void run() {
        BundleLog.LOG.info("Start download file");
        try {
            DataInputStream dataInputStream = new DataInputStream(this.con.getInputStream());
            byte[] buffer = new byte[2048];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int size = -1;
            while ((size = dataInputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, size);
                this.progressBarFrame.next(baos.size());
                DownLoadDialog.STATUS s = this.progressBarFrame.getStatus();
                if (!s.equals((Object)DownLoadDialog.STATUS.CANCELED)) continue;
                this.setStatus(s);
                break;
            }
            dataInputStream.close();
            if (!DownLoadDialog.STATUS.CANCELED.equals((Object)this.status)) {
                this.result = baos.toByteArray();
                this.setStatus(DownLoadDialog.STATUS.DOWNLOADED);
            }
        }
        catch (Exception e) {
            this.setStatus(DownLoadDialog.STATUS.ERROR);
            BundleLog.LOG.error("Download file error", e);
        }
        BundleLog.LOG.info("End download file");
        this.progressBarFrame.setFinish(true);
        if (this.progressBarFrame.isVisible()) {
            this.progressBarFrame.setVisible(false);
        }
    }

    public DownLoadDialog.STATUS download() {
        this.maxProgress = this.con.getContentLength();
        this.progressBarFrame.startDownload(this.maxProgress);
        this.run();
        if (DownLoadDialog.STATUS.CANCELED.equals((Object)this.progressBarFrame.getStatus())) {
            this.setStatus(this.progressBarFrame.getStatus());
        }
        return this.getStatus();
    }

    public byte[] getResult() {
        return this.result;
    }

    public synchronized DownLoadDialog.STATUS getStatus() {
        return this.status;
    }

    private synchronized void setStatus(DownLoadDialog.STATUS st) {
        this.status = st;
    }
}

