/*
 * Decompiled with CFR 0.152.
 */
package kz.ecc.nursign.helpers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.Objects;
import javax.swing.SwingUtilities;
import kz.ecc.nursign.gui.DownLoadDialog;
import kz.ecc.nursign.gui.GUIFabric;
import kz.ecc.nursign.osgi.BundleLog;

public class Uploader {
    private static final int BUFFER_SIZE = 8192;
    private OutputStream os;
    private DownLoadDialog dialog;
    private int maxProgress;
    private File file;
    private DownLoadDialog.STATUS status;

    public Uploader(OutputStream os) {
        this.os = os;
        this.dialog = GUIFabric.getDownLoadDialog();
        this.dialog.setVisible(false);
    }

    public void run() {
        BundleLog.LOG.info("Start upload file: " + new Date());
        Objects.requireNonNull(this.os);
        Path filePath = this.file.toPath();
        try (InputStream is = Files.newInputStream(filePath, new OpenOption[0]);){
            int n;
            int nread = 0;
            byte[] buf = new byte[8192];
            while ((n = is.read(buf)) > 0) {
                this.os.write(buf, 0, n);
                this.dialog.next(nread += n);
                DownLoadDialog.STATUS s = this.dialog.getStatus();
                if (!DownLoadDialog.STATUS.CANCELED.equals((Object)s)) continue;
                this.setStatus(s);
                break;
            }
        }
        catch (IOException e) {
            this.setStatus(DownLoadDialog.STATUS.ERROR);
            BundleLog.LOG.error("UPLOAD FILE ERROR", e);
            e.printStackTrace();
        }
        BundleLog.LOG.info("End upload File " + new Date());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Uploader.this.dialog.setFinish(true);
                Uploader.this.dialog.setVisible(false);
            }
        });
    }

    public DownLoadDialog.STATUS upload(File file) {
        this.file = file;
        this.maxProgress = (int)file.length();
        BundleLog.LOG.debug("\u041e\u0431\u0449\u0438\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u0444\u0430\u0439\u043b\u0430 : " + this.maxProgress);
        this.dialog.startDownload(this.maxProgress);
        this.run();
        if (DownLoadDialog.STATUS.CANCELED.equals((Object)this.dialog.getStatus())) {
            this.setStatus(this.dialog.getStatus());
        }
        return this.getStatus();
    }

    public synchronized DownLoadDialog.STATUS getStatus() {
        return this.status;
    }

    public synchronized void setStatus(DownLoadDialog.STATUS status) {
        this.status = status;
    }
}

