/*
 * Decompiled with CFR 0.152.
 */
package kz.ecc.nursign.model;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.TimeZone;
import kz.ecc.nursign.gui.util.GUITools;
import kz.ecc.nursign.model.TokenDetail;
import kz.ecc.nursign.utils.NurSignUtil;
import kz.ecc.nursign.utils.SignUtil;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.x509.X509Name;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.utils.X509Util;
import kz.gov.pki.reference.KeyStoreEntry;

public class KeyEntry
extends KeyStoreEntry {
    private TokenDetail tokenDetail;
    private String period;
    private boolean expired = false;
    private boolean current = false;
    private String orgName;
    private String certType;
    private String certTypeString;
    private String bin;
    private String iin;

    public String getCertType() {
        return this.certType;
    }

    public String getTypeDescription() {
        return this.certTypeString;
    }

    public KeyEntry(KeyStoreEntry keyStoreEntry, TokenDetail tokenDetail) throws CertificateException, IOException, ProviderUtilException {
        super(keyStoreEntry.getKeyId(), keyStoreEntry.getAlgorithm(), keyStoreEntry.getX509Certificate());
        this.tokenDetail = tokenDetail;
        if (this.getX509Certificate() != null) {
            this.orgName = X509Util.getRdn((X509Name)X509Util.getSubjectDN((X509Certificate)this.getX509Certificate()), (DERObjectIdentifier)X509Name.O, (int)0);
            this.bin = X509Util.getRdn((X509Name)X509Util.getSubjectDN((X509Certificate)this.getX509Certificate()), (DERObjectIdentifier)X509Name.OU, (int)0);
            this.iin = X509Util.getRdn((X509Name)X509Util.getSubjectDN((X509Certificate)this.getX509Certificate()), (DERObjectIdentifier)X509Name.SERIALNUMBER, (int)0);
            this.period = this.parseDateToString(this.getX509Certificate().getNotBefore()) + " - " + this.parseDateToString(this.getX509Certificate().getNotAfter());
            try {
                this.getX509Certificate().checkValidity();
            }
            catch (CertificateExpiredException | CertificateNotYetValidException e) {
                this.expired = true;
            }
            this.certType = SignUtil.getCertType(this.getX509Certificate());
            this.certTypeString = NurSignUtil.getCertTypeString(this.certType);
        }
    }

    public Storage getStorage() {
        return this.tokenDetail.getStorage();
    }

    public String getContainer() {
        return this.tokenDetail.getEntryName();
    }

    private String parseDateToString(Date date) {
        if (date == null) {
            return null;
        }
        String pattern = "dd.MM.yyyy (HH:mm)";
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        df.setTimeZone(TimeZone.getTimeZone("Asia/Almaty"));
        return df.format(date);
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean current) {
        this.current = current;
    }

    public String getTooltip() {
        StringBuilder sb = new StringBuilder("<HTML>");
        ResourceBundle b = GUITools.getResourceBundle();
        sb.append(b.getString("form.main_dialog.cert_type")).append(" : ").append(this.getTypeDescription()).append("(").append(this.getAlgorithm()).append(")<br/> ");
        if (this.getX509Certificate() == null) {
            sb.append("\u2014").append("<br/>");
            sb.append("keyId : ").append(this.getKeyId());
        } else {
            sb.append(b.getString("form.main_dialog.owner_name")).append(this.getSubjectCn()).append("<br/>");
            sb.append(b.getString("form.main_dialog.cert_date")).append(this.period).append("<br/>");
            sb.append("keyId : ").append(this.getKeyId()).append("<br/>");
            sb.append(b.getString("form.main_dialog.serial_num")).append(this.getSerialNumber()).append("<br/>");
            sb.append(b.getString("form.main_dialog.org_name")).append(this.orgName);
        }
        return sb.toString();
    }

    public String getBin() {
        return this.bin;
    }

    public String getIin() {
        return this.iin;
    }

    public String toButtonText() {
        StringBuilder sb = new StringBuilder("<HTML>");
        sb.append(this.getSubjectCn()).append("(").append(this.getBin()).append(" : ").append(this.getIin()).append(")");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getAlgorithm()).append(" : ");
        if (this.getX509Certificate() == null) {
            sb.append("\u2014").append(":");
            sb.append(this.getKeyId());
        } else {
            sb.append(this.getSubjectCn()).append(":");
            sb.append(this.getKeyId()).append("<@>");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        KeyEntry that = (KeyEntry)((Object)obj);
        return Objects.equals(this.tokenDetail, that.tokenDetail) && Objects.equals(this.getKeyId(), that.getKeyId()) && Objects.equals(this.getSerialNumber(), that.getSerialNumber());
    }

    public int hashCode() {
        return Objects.hash(this.tokenDetail, this.getKeyId(), this.getSerialNumber());
    }
}

