/*
 * Decompiled with CFR 0.152.
 */
package kz.ecc.nursign.services;

import java.io.UnsupportedEncodingException;
import kz.ecc.nursign.exceptions.NURSignException;
import kz.ecc.nursign.gui.GUIFabric;
import kz.ecc.nursign.gui.MessageDialog;
import kz.ecc.nursign.gui.util.GUITools;
import kz.ecc.nursign.osgi.BundleLog;
import kz.ecc.nursign.services.Signer;
import kz.ecc.nursign.utils.PropertyUtil;
import kz.gov.pki.osgi.layer.api.ModuleService;
import kz.gov.pki.provider.exception.ProviderUtilException;
import org.json.JSONObject;

public class NurSignService
implements ModuleService {
    private static final String TYPE = "type";
    private static final String TEXT = "text";
    private static final String XML = "xml";
    private static final String BINARY = "binary";
    private static final String FILE = "file";
    private static final String VERSION = "version";
    static final String ORIGIN = "origin";
    private static final String MULTITEXT = "multitext";
    private static final String version = "1.0.0";
    private Signer signer = new Signer();

    public NurSignService() {
        PropertyUtil.init();
    }

    public String process(String jsonString, String origin) {
        this.log("getRequesr: ");
        this.log(jsonString);
        JSONObject jOrigin = new JSONObject(origin);
        origin = jOrigin.getString(ORIGIN);
        String utf8String = null;
        try {
            utf8String = new String(jsonString.getBytes("UTF-8"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.log("!!@!!@!!@!", e);
            utf8String = jsonString;
        }
        JSONObject requestJSON = new JSONObject(utf8String);
        requestJSON.put(ORIGIN, (Object)origin);
        String type = requestJSON.optString(TYPE);
        this.log("origin = " + origin + " and " + TYPE + " = " + type);
        JSONObject responseMessage = null;
        String errorMessage = null;
        try {
            switch (type) {
                case "xml": {
                    responseMessage = this.signer.signXml(requestJSON);
                    break;
                }
                case "text": {
                    responseMessage = this.signer.signText(requestJSON);
                    break;
                }
                case "binary": {
                    responseMessage = this.signer.signBinary(requestJSON);
                    break;
                }
                case "file": {
                    responseMessage = this.signer.signFile(requestJSON);
                    break;
                }
                case "multitext": {
                    responseMessage = this.signer.signMultiText(requestJSON);
                    break;
                }
                case "version": {
                    JSONObject vers = new JSONObject();
                    vers.put(VERSION, (Object)version);
                    JSONObject responseJSON = new JSONObject();
                    responseJSON.put("result", (Object)vers);
                    responseJSON.put("errorCode", (Object)"NONE");
                    return responseJSON.toString();
                }
                default: {
                    responseMessage = new JSONObject();
                    responseMessage.put("errorCode", (Object)"500");
                    break;
                }
            }
        }
        catch (NURSignException e) {
            errorMessage = GUITools.getResourceBundle().getString(e.getExceptionTypes().name());
            MessageDialog messageDialog = GUIFabric.showErrorMessage();
            messageDialog.showMessage(errorMessage);
        }
        catch (ProviderUtilException e) {
            errorMessage = e.getMessage();
            MessageDialog messageDialog = GUIFabric.showErrorMessage();
            messageDialog.showMessage(errorMessage);
        }
        catch (Exception e) {
            BundleLog.LOG.error("Sign text error", e);
            errorMessage = GUITools.getResourceBundle().getString(NURSignException.ExceptionTypes.SIGN_PLAIN_DATA_FAILED.name());
            MessageDialog messageDialog = GUIFabric.showErrorMessage();
            messageDialog.showMessage(errorMessage);
        }
        if (errorMessage != null && !errorMessage.isEmpty()) {
            responseMessage = new JSONObject();
            responseMessage.put("errorCode", (Object)"500");
            responseMessage.put("errorMessage", (Object)errorMessage);
            this.log("ERROR: " + errorMessage);
        } else {
            this.log("Signed SUCCESSFUL!");
        }
        if (responseMessage != null) {
            return responseMessage.toString();
        }
        return null;
    }

    private void log(String value) {
        BundleLog.LOG.info(value);
    }

    private void log(String value, Throwable e) {
        BundleLog.LOG.error(value, e);
    }
}

