/*
 * Decompiled with CFR 0.152.
 */
package kz.ecc.nursign.services;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import kz.ecc.nursign.common.ServiceSource;
import kz.ecc.nursign.exceptions.NURSignException;
import kz.ecc.nursign.gui.MainDialog;
import kz.ecc.nursign.gui.PasswordDialog;
import kz.ecc.nursign.gui.filechooser.FileChooser;
import kz.ecc.nursign.gui.filechooser.FileChooserDialog;
import kz.ecc.nursign.gui.util.GUITools;
import kz.ecc.nursign.gui.util.GUIUtilities;
import kz.ecc.nursign.model.KeyEntry;
import kz.ecc.nursign.model.TokenDetail;
import kz.ecc.nursign.osgi.BundleLog;
import kz.ecc.nursign.osgi.BundleProvider;
import kz.ecc.nursign.utils.HttpUtil;
import kz.ecc.nursign.utils.NurSignUtil;
import kz.ecc.nursign.utils.PropertyUtil;
import kz.ecc.nursign.utils.SignUtil;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedData;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.exception.ProviderUtilExceptionCode;
import kz.gov.pki.provider.utils.CMSUtil;
import kz.gov.pki.provider.utils.KeyStoreUtil;
import kz.gov.pki.provider.utils.XMLUtil;
import kz.gov.pki.provider.utils.model.SigningEntity;
import kz.gov.pki.provider.utils.model.TSAProfile;
import org.json.JSONObject;

public class Signer {
    private static final String SOURCE = "source";
    private static final String LOCAL = "local";
    private static final String DATA = "data";
    private static final String UPLOAD_URL = "upload_url";
    private static final String NEED_HASH = "need_hash";
    private static final String CHECK_BY_HASH_URL = "/ru/files/check_by_hash/";
    private static final String MD5 = "MD5";
    private static final String SHA256 = "SHA256";
    private static final String TOKEN = "token";
    private static final String URL_UPLOAD = "url_upload";
    private static final String SIGNATURE = "signature";
    private static final String FILE_NAME = "file_name";
    private static final String FILE_PATH = "filePath";
    static final String ERROR_MESSAGE = "errorMessage";
    static final String ERROR_CODE = "errorCode";
    private static final String RESULT = "result";
    private static final String NONE = "NONE";
    private static final String HASH = "hash";
    private static final String ITEMS = "items";

    public JSONObject signText(JSONObject obj) throws NURSignException, ProviderUtilException, IOException {
        String utf8String = obj.optString(DATA);
        SigningEntity signingEntity = this.getSigningEntity();
        JSONObject responseMessage = new JSONObject();
        if (signingEntity != null) {
            CMSSignedData cms = CMSUtil.createCAdES((SigningEntity)signingEntity, (byte[])utf8String.getBytes(StandardCharsets.UTF_8), (boolean)false, (boolean)false, (Provider)BundleProvider.KALKANCRYPT.getProvider());
            cms = CMSUtil.applyCAdEST((CMSSignedData)cms, (SigningEntity)signingEntity, (TSAProfile)new TSAProfile(), (Provider)BundleProvider.KALKANCRYPT.getProvider());
            responseMessage.put(ERROR_CODE, (Object)NONE);
            responseMessage.put(RESULT, (Object)Base64.getEncoder().encodeToString(cms.getEncoded()));
        }
        return responseMessage;
    }

    public JSONObject signBinary(JSONObject obj) throws NURSignException, ProviderUtilException, IOException {
        byte[] data;
        String source = obj.optString(SOURCE, LOCAL);
        if (LOCAL.equals(source)) {
            data = obj.optString(DATA).getBytes(StandardCharsets.UTF_8);
        } else {
            String url = obj.optString(UPLOAD_URL);
            if (!url.isEmpty()) {
                try {
                    byte[] data2sign = HttpUtil.downloadRemoteFile(url);
                    if ((long)data2sign.length > PropertyUtil.getMaxFileSize()) {
                        throw new NURSignException(NURSignException.ExceptionTypes.MAX_FILE_SIZE_EXCEEDED);
                    }
                    data = Base64.getEncoder().encode(data2sign);
                }
                catch (Exception e) {
                    if (e instanceof NURSignException) {
                        throw (NURSignException)e;
                    }
                    throw new NURSignException(NURSignException.ExceptionTypes.OTHER, e);
                }
            } else {
                throw new NURSignException(NURSignException.ExceptionTypes.NOT_VALID_URL);
            }
        }
        SigningEntity entity = this.getSigningEntity();
        JSONObject responseMessage = new JSONObject();
        if (entity != null) {
            CMSSignedData cms = CMSUtil.createCAdES((SigningEntity)entity, (byte[])Base64.getDecoder().decode(data), (boolean)false, (boolean)false, (Provider)BundleProvider.KALKANCRYPT.getProvider());
            responseMessage.put(ERROR_CODE, (Object)NONE);
            responseMessage.put(RESULT, (Object)Base64.getEncoder().encodeToString(cms.getEncoded()));
            if (!obj.optString(NEED_HASH).isEmpty()) {
                String md5 = SignUtil.getHash(data, MD5);
                String sha256 = SignUtil.getHash(data, SHA256);
                JSONObject hash = new JSONObject();
                hash.put(MD5, (Object)md5);
                hash.put(SHA256, (Object)sha256);
                responseMessage.put(HASH, (Object)hash);
            }
        }
        return responseMessage;
    }

    public JSONObject signXml(JSONObject obj) throws Exception {
        String xmlData;
        String source = obj.optString(SOURCE, LOCAL);
        if (LOCAL.equals(source)) {
            xmlData = obj.getString(DATA);
        } else {
            String url = obj.getString(UPLOAD_URL);
            if (!url.isEmpty()) {
                try {
                    byte[] dataXml = HttpUtil.downloadRemoteFile(url);
                    xmlData = new String(dataXml);
                }
                catch (Exception e) {
                    throw new NURSignException(NURSignException.ExceptionTypes.DOWNLOAD_FILE_EXCEPTION, e);
                }
            } else {
                throw new NURSignException(NURSignException.ExceptionTypes.NOT_VALID_URL);
            }
        }
        SigningEntity signingEntity = this.getSigningEntity();
        JSONObject response = new JSONObject();
        if (signingEntity != null) {
            BundleLog.LOG.info("signingEntity is not null");
            String signedXml = XMLUtil.createXmlSignature((SigningEntity)signingEntity, (String)xmlData, (Provider)BundleProvider.KALKANCRYPT.getProvider());
            response.put(ERROR_CODE, (Object)NONE);
            response.put(RESULT, (Object)signedXml);
        } else {
            BundleLog.LOG.error("signingEntity is NULL", null);
        }
        return response;
    }

    public JSONObject signFile(JSONObject obj) throws NURSignException, IOException, ProviderUtilException, NoSuchAlgorithmException, KeyManagementException {
        String propFilename = PropertyUtil.get("testFileName");
        String fileName = propFilename != null && !propFilename.isEmpty() ? propFilename : GUIUtilities.chooseFile("");
        File file = new File(fileName);
        if (file.length() > PropertyUtil.getMaxFileSize()) {
            throw new NURSignException(NURSignException.ExceptionTypes.MAX_FILE_SIZE_EXCEEDED);
        }
        byte[] data = NurSignUtil.getBase64FromFile(file.getPath());
        JSONObject responseMessage = new JSONObject();
        SigningEntity signingEntity = this.getSigningEntity();
        if (signingEntity != null) {
            CMSSignedData cms = CMSUtil.createCAdES((SigningEntity)signingEntity, (byte[])Base64.getDecoder().decode(data), (boolean)false, (boolean)false, (Provider)BundleProvider.KALKANCRYPT.getProvider());
            String signature = Base64.getEncoder().encodeToString(cms.getEncoded());
            responseMessage.put(ERROR_CODE, (Object)NONE);
            responseMessage.put(RESULT, (Object)signature);
            String md5 = SignUtil.getHash(data, MD5);
            String sha256 = SignUtil.getHash(data, SHA256);
            StringBuilder sb = new StringBuilder();
            sb.append("md5=").append(md5).append("&sha256=").append(sha256);
            String origin = obj.getString("origin").concat(CHECK_BY_HASH_URL);
            boolean haveFile = HttpUtil.checkFileExists(origin, sb.toString());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(TOKEN, obj.getString(TOKEN));
            String urlUpload = obj.getString(URL_UPLOAD);
            params.put(SIGNATURE, signature);
            if (!haveFile) {
                BundleLog.LOG.info("file " + file.getPath() + " not exists on server");
            } else {
                BundleLog.LOG.info("file " + file.getPath() + "  exists on server");
                params.put(MD5, md5);
                params.put(SHA256, sha256);
                params.put(FILE_NAME, file.getName());
            }
            String result = HttpUtil.uploadFile(urlUpload, params, file, haveFile);
            JSONObject resultd = new JSONObject(result);
            JSONObject dataRes = new JSONObject();
            Set keys = resultd.keySet();
            for (String k : keys) {
                dataRes.put(k, resultd.get(k));
            }
            dataRes.put(FILE_PATH, (Object)file.getPath());
            dataRes.put(SIGNATURE, (Object)signature);
            responseMessage.put(RESULT, (Object)dataRes);
        }
        return responseMessage;
    }

    public JSONObject signMultiText(JSONObject obj) throws NURSignException, ProviderUtilException, IOException {
        JSONObject dataArray = obj.getJSONObject(DATA);
        Iterator it = dataArray.keys();
        SigningEntity signingEntity = this.getSigningEntity();
        JSONObject responseItems = new JSONObject();
        JSONObject responseMessage = new JSONObject();
        if (signingEntity != null) {
            while (it.hasNext()) {
                String key = (String)it.next();
                CMSSignedData cms = CMSUtil.createCAdES((SigningEntity)signingEntity, (byte[])dataArray.optString(key).getBytes(StandardCharsets.UTF_8), (boolean)false, (boolean)false, (Provider)BundleProvider.KALKANCRYPT.getProvider());
                cms = CMSUtil.applyCAdEST((CMSSignedData)cms, (SigningEntity)signingEntity, (TSAProfile)new TSAProfile(), (Provider)BundleProvider.KALKANCRYPT.getProvider());
                responseItems.put(key, (Object)Base64.getEncoder().encodeToString(cms.getEncoded()));
            }
            JSONObject items = new JSONObject();
            items.put(ITEMS, (Object)responseItems);
            responseMessage.put(ERROR_CODE, (Object)NONE);
            responseMessage.put(RESULT, (Object)items);
        }
        return responseMessage;
    }

    private SigningEntity getSigningEntity() throws NURSignException {
        try {
            List<TokenDetail> tokens = ServiceSource.getTokens();
            Set<KeyEntry> entries = ServiceSource.getKeyEntries();
            KeyEntry keyEntry = null;
            char[] password = new char[]{};
            if (entries.size() == 0 && tokens.size() == 1) {
                TokenDetail tokenDetail = tokens.get(0);
                if (tokenDetail.getStorage() == Storage.PKCS12) {
                    FileChooserDialog fileChooserDialog = new FileChooserDialog(new JFrame(), FileChooser.FileType.P12, "", GUITools.getResourceBundle().getString("form.main_dialog.select_certificate"));
                    String path = fileChooserDialog.getSelectedFilePath();
                    tokenDetail.setEntryName(path);
                    if (tokenDetail.getEntryName() != null) {
                        PasswordDialog passDialog = new PasswordDialog(new Frame(), tokenDetail.getName());
                        passDialog.setVisible(true);
                        if (passDialog.isOk()) {
                            password = passDialog.getPassword().toCharArray();
                            keyEntry = ServiceSource.getPKCS12KeyEntry(tokenDetail, password);
                        }
                    }
                }
            } else {
                MainDialog md = new MainDialog(GUITools.getResourceBundle(), tokens, entries);
                if (md.isSign()) {
                    password = md.getPassword();
                    keyEntry = ServiceSource.getSelectedKeyEntry();
                }
            }
            SigningEntity signingEntity = null;
            if (keyEntry != null) {
                KeyStore ks = KeyStoreUtil.getKeyStore((Storage)keyEntry.getStorage(), (String)keyEntry.getContainer(), (char[])password, (Provider)BundleProvider.KALKANCRYPT.getProvider());
                signingEntity = KeyStoreUtil.getSigningEntity((KeyStore)ks, (String)keyEntry.getKeyId(), (char[])password);
            }
            return signingEntity;
        }
        catch (ProviderUtilException e) {
            if (e.getCode().equals((Object)ProviderUtilExceptionCode.WRONG_KEYSTORE_PASSWORD)) {
                throw new NURSignException(NURSignException.ExceptionTypes.WRONG_PASSWORD);
            }
            if (e.getCode().equals((Object)ProviderUtilExceptionCode.TIMESTAMP_CREATION_FAILURE)) {
                throw new NURSignException(NURSignException.ExceptionTypes.TIMESTAMP_CREATION_FAILURE);
            }
            throw new NURSignException(NURSignException.ExceptionTypes.SIGN_PLAIN_DATA_FAILED);
        }
        catch (Exception e) {
            throw new NURSignException(NURSignException.ExceptionTypes.SIGN_PLAIN_DATA_FAILED);
        }
    }
}

