/*
 * Decompiled with CFR 0.152.
 */
package kz.ecc.nursign.utils;

import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kz.ecc.nursign.exceptions.NURSignException;
import kz.ecc.nursign.osgi.BundleLog;
import kz.ecc.nursign.utils.PropertyUtil;

public class ConnectionUtil {
    private static String host;
    private static String port;
    private static String userName;
    private static String userPassword;
    private static boolean isNTLM;
    private static boolean isConfigured;
    private static boolean useProxy;

    public static void init() {
        ConnectionUtil.reInit();
    }

    private static void reInit() {
        host = PropertyUtil.getProxyHost();
        port = PropertyUtil.getProxyPort();
        userName = PropertyUtil.getAuthLogin();
        userPassword = PropertyUtil.getAuthPassword();
        isNTLM = PropertyUtil.useNTLM();
        isConfigured = true;
        useProxy = PropertyUtil.useProxy();
        if (useProxy && host != null && !host.isEmpty()) {
            BundleLog.LOG.info("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c \u043f\u0440\u043e\u043a\u0441\u0438\nhost = " + host + "\nport = " + port);
        }
        if (isNTLM) {
            BundleLog.LOG.info("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f NTLM");
        }
    }

    private static HttpURLConnection getHttpUrlConnection(URL url) throws IOException {
        HttpURLConnection connection = null;
        if (isNTLM) {
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("GET");
        } else {
            if (useProxy && host != null && !host.isEmpty()) {
                ConnectionUtil.setWebProxy(host, port);
            }
            connection = (HttpURLConnection)url.openConnection();
        }
        return connection;
    }

    public static HttpURLConnection getUrlConnection(URL url) throws NoSuchAlgorithmException, KeyManagementException, IOException, NURSignException {
        if (!ConnectionUtil.checkUrl(url).booleanValue()) {
            throw new NURSignException(NURSignException.ExceptionTypes.NOT_VALID_URL);
        }
        String protocol = url.getProtocol();
        if (protocol.equalsIgnoreCase("https")) {
            return ConnectionUtil.getHttpsUrlConnection(url);
        }
        return ConnectionUtil.getHttpUrlConnection(url);
    }

    private static Boolean checkUrl(URL url) throws NURSignException {
        String host = url.getHost().trim();
        List<String> validHosts = Arrays.asList(".gov.kz", ".ecc.kz", ".minfin.kz");
        for (String s : validHosts) {
            if (!host.endsWith(s)) continue;
            return true;
        }
        for (String s : PropertyUtil.getAllowOrigins()) {
            if (!host.endsWith(s)) continue;
            return true;
        }
        return false;
    }

    public static Boolean checkUrl(String url) {
        try {
            URL url1 = new URL(url);
            return ConnectionUtil.checkUrl(url1);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static HttpsURLConnection getHttpsUrlConnection(URL url) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        if (!isConfigured) {
            throw new IllegalStateException("ConnectionUtil not configured");
        }
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }
        }};
        SSLContext sc = SSLContext.getInstance("TLSv1.2");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        HttpsURLConnection connection = null;
        ConnectionUtil.setAuth();
        if (isNTLM) {
            connection = (HttpsURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("GET");
        } else {
            if (useProxy && host != null && !host.isEmpty()) {
                ConnectionUtil.setWebProxy(host, port);
            }
            connection = (HttpsURLConnection)url.openConnection();
        }
        return connection;
    }

    private static void setWebProxy(String hostName, String port) {
        if (hostName != null) {
            System.setProperty("http.proxyHost", hostName);
            System.setProperty("https.proxyHost", hostName);
            if (port != null) {
                System.setProperty("http.proxyPort", port);
                System.setProperty("https.proxyPort", port);
            }
        }
    }

    private static void setAuth() {
        if (userName != null && !userName.isEmpty()) {
            Authenticator.setDefault(new MyAuthenticator());
        }
    }

    static {
        isNTLM = false;
        isConfigured = true;
        useProxy = false;
    }

    static class MyAuthenticator
    extends Authenticator {
        MyAuthenticator() {
        }

        @Override
        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(userName, userPassword.toCharArray());
        }
    }
}

