/*
 * Decompiled with CFR 0.152.
 */
package kz.ecc.nursign.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Set;
import kz.ecc.nursign.exceptions.NURSignException;
import kz.ecc.nursign.gui.DownLoadDialog;
import kz.ecc.nursign.helpers.Downloader;
import kz.ecc.nursign.helpers.Uploader;
import kz.ecc.nursign.osgi.BundleLog;
import kz.ecc.nursign.utils.ConnectionUtil;

public class HttpUtil {
    private static final String CRLF = "\r\n";
    private static final String FALSE = "false";

    public static byte[] downloadRemoteFile(String url) throws NURSignException, NoSuchAlgorithmException, IOException, KeyManagementException {
        Downloader downloader = new Downloader(url);
        DownLoadDialog.STATUS st = downloader.download();
        if (DownLoadDialog.STATUS.DOWNLOADED.equals((Object)st)) {
            return downloader.getResult();
        }
        if (DownLoadDialog.STATUS.CANCELED.equals((Object)st)) {
            throw new NURSignException(NURSignException.ExceptionTypes.CANCEL);
        }
        if (DownLoadDialog.STATUS.ERROR.equals((Object)st)) {
            throw new NURSignException(NURSignException.ExceptionTypes.DOWNLOAD_FILE_EXCEPTION);
        }
        throw new NURSignException(NURSignException.ExceptionTypes.OTHER);
    }

    public static boolean checkFileExists(String urlString, String param) throws IOException, NoSuchAlgorithmException, KeyManagementException, NURSignException {
        byte[] data;
        block20: {
            URL url = new URL(urlString);
            HttpURLConnection con = ConnectionUtil.getUrlConnection(url);
            con.setRequestMethod("POST");
            con.setDoInput(true);
            con.setDoOutput(true);
            data = param.getBytes(StandardCharsets.UTF_8);
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            con.setRequestProperty("Content-Length", Integer.toString(data.length));
            try (OutputStream os = con.getOutputStream();){
                os.write(data);
            }
            con.connect();
            int responseCode = con.getResponseCode();
            if (responseCode == 200) {
                try (InputStream is = con.getInputStream();
                     ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    int bytesRead;
                    byte[] buffer = new byte[2048];
                    while ((bytesRead = is.read(buffer)) != -1) {
                        baos.write(buffer, 0, bytesRead);
                    }
                    data = baos.toByteArray();
                    break block20;
                }
            }
            BundleLog.LOG.error("remote service returned code " + responseCode, null);
            throw new NURSignException(NURSignException.ExceptionTypes.CHECK_FILE_EXIST_ERROR);
        }
        String result = new String(data, StandardCharsets.UTF_8);
        return !FALSE.equals(result);
    }

    public static String uploadFile(String stringUrl, Map<String, String> params, File file, Boolean isHaveFile) throws IOException, NoSuchAlgorithmException, KeyManagementException, NURSignException {
        String result;
        URL url = new URL(stringUrl);
        String boundary = Long.toHexString(System.currentTimeMillis());
        HttpURLConnection con = ConnectionUtil.getUrlConnection(url);
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        try (OutputStream os = con.getOutputStream();
             PrintWriter writer = new PrintWriter(new OutputStreamWriter(os));){
            if (params.size() > 0) {
                Set<String> keys = params.keySet();
                for (String key : keys) {
                    writer.append("--").append(boundary).append(CRLF);
                    writer.append("Content-Disposition: form-data; name=\"").append(key).append("\"").append(CRLF);
                    writer.append(CRLF).append(params.get(key)).append(CRLF);
                }
            }
            if (file.exists() && file.isFile()) {
                writer.append("--").append(boundary).append(CRLF);
                BundleLog.LOG.info("file_name = " + file.getName());
                String d = new String(file.getName().getBytes(StandardCharsets.UTF_8));
                BundleLog.LOG.info("file_name_ = " + d);
                String fName = "Content-Disposition: form-data; name=\"userfile\"; fileName=\"" + d + "\"";
                writer.append(fName).append(CRLF);
                writer.append("Content-Type: application/octet-stream").append(CRLF);
                writer.append(CRLF).flush();
                if (!isHaveFile.booleanValue()) {
                    Uploader uploader = new Uploader(os);
                    DownLoadDialog.STATUS st = uploader.upload(file);
                    os.flush();
                    if (!DownLoadDialog.STATUS.DOWNLOADED.equals((Object)st)) {
                        if (DownLoadDialog.STATUS.CANCELED.equals((Object)st)) {
                            throw new NURSignException(NURSignException.ExceptionTypes.CANCEL);
                        }
                        if (DownLoadDialog.STATUS.ERROR.equals((Object)st)) {
                            throw new NURSignException(NURSignException.ExceptionTypes.DOWNLOAD_FILE_EXCEPTION);
                        }
                    }
                }
            } else {
                BundleLog.LOG.info("file not fined");
                throw new NURSignException(NURSignException.ExceptionTypes.UPLOAD_FILE_NOT_FOUND);
            }
            writer.append(CRLF).flush();
            writer.append("--").append(boundary).append("--").append(CRLF).flush();
        }
        int responseCode = con.getResponseCode();
        BundleLog.LOG.info("response message : " + con.getResponseMessage());
        try (InputStream is = con.getInputStream();
             ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int bytesRead;
            byte[] buffer = new byte[2048];
            while ((bytesRead = is.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            byte[] data = baos.toByteArray();
            result = new String(data, StandardCharsets.UTF_8);
        }
        System.out.println(result);
        BundleLog.LOG.debug("Response::: " + result);
        if (responseCode != 200) {
            BundleLog.LOG.error("\u0423\u0434\u0430\u043b\u0435\u043d\u043d\u044b\u0439 \u0441\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u0432\u0435\u0442\u0438\u043b \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c " + responseCode, null);
            throw new NURSignException(NURSignException.ExceptionTypes.UPLOAD_FILE_EXCEPTION);
        }
        return result;
    }
}

