/*
 * Decompiled with CFR 0.152.
 */
package kz.ecc.nursign.utils;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.ResourceBundle;
import kz.ecc.nursign.exceptions.NURSignException;
import kz.ecc.nursign.gui.util.GUITools;

public class NurSignUtil {
    private static Boolean checkUrl(URL url) {
        String host = url.getHost().trim();
        List<String> validHosts = Arrays.asList(".gov.kz", ".ecc.kz", ".minfin.kz");
        for (String s : validHosts) {
            if (!host.endsWith(s)) continue;
            return true;
        }
        return false;
    }

    public static Boolean checkUrl(String url) {
        try {
            URL url1 = new URL(url);
            return NurSignUtil.checkUrl(url1);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getCertTypeString(String certType) {
        ResourceBundle bundle = GUITools.getResourceBundle();
        switch (certType) {
            case "A": {
                return bundle.getString("certificateDetail.type.authentication");
            }
            case "S": {
                return bundle.getString("certificateDetail.type.signature");
            }
            case "SA": {
                return bundle.getString("certificateDetail.type.authAndSign");
            }
        }
        return "";
    }

    public static byte[] getBase64FromFile(String filePath) throws NURSignException {
        try {
            Path path = Paths.get(filePath, new String[0]);
            byte[] fileBytes = Files.readAllBytes(path);
            return Base64.getEncoder().encode(fileBytes);
        }
        catch (IOException e) {
            throw new NURSignException(NURSignException.ExceptionTypes.FILE_NOT_FOUND, e);
        }
    }
}

