/*
 * Decompiled with CFR 0.152.
 */
package kz.ecc.nursign.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kz.ecc.nursign.osgi.BundleLog;

public class PropertyUtil {
    private static final String PROPERTY_FILE_NAME = "nursign.properties";
    private static final String YES = "Y";
    private static Lock lock = new ReentrantLock();
    private static Properties properties = new Properties();
    private static long maxFileSize = -1L;
    private static String DIR_NAME = "config";
    private static List<String> allowOrigins = new ArrayList<String>();

    public static void init() {
        if (!PropertyUtil.loadProperty()) {
            PropertyUtil.setDefaultProperty();
        }
        PropertyUtil.setMaxFileSize();
        String allowOriginsString = properties.getProperty("allow_origins", "");
        if (!allowOriginsString.isEmpty()) {
            for (String s : allowOriginsString.split(",")) {
                allowOrigins.add(s.trim());
            }
        }
    }

    public static void reLoadProperty() {
        PropertyUtil.loadProperty();
        PropertyUtil.setMaxFileSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadProperty() {
        PropertyUtil.log("Load property");
        InputStream is = null;
        if (lock.tryLock()) {
            try {
                File file = new File(PropertyUtil.getUserDataDirectory(), PROPERTY_FILE_NAME);
                is = new FileInputStream(file);
                if (is == null) {
                    boolean bl = false;
                    return bl;
                }
                properties.load(is);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                PropertyUtil.logError("property file not found : " + e.getMessage());
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        PropertyUtil.logError("File close error : " + e.getMessage());
                    }
                }
                lock.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveProperty() {
        OutputStream os = null;
        try {
            if (lock.tryLock()) {
                File dir = new File(PropertyUtil.getUserDataDirectory());
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                File file = new File(PropertyUtil.getUserDataDirectory(), PROPERTY_FILE_NAME);
                os = new FileOutputStream(file);
                properties.store(os, null);
            }
        }
        catch (Exception e) {
            PropertyUtil.logError("File save error : " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    PropertyUtil.logError("output stream close error : " + e.getMessage());
                }
            }
        }
        PropertyUtil.setMaxFileSize();
        return true;
    }

    private static void setDefaultProperty() {
        PropertyUtil.log("property file not found? set default parameters");
        properties.setProperty("auth_login", "");
        properties.setProperty("allow_adresses", "https://egzdev.ecc.kz,http://127.0.0.1:8000");
        properties.setProperty("use_ntlm", "N");
        properties.setProperty("use_auth", "N");
        properties.setProperty("auth_pass", "");
        properties.setProperty("max_file_size", "20");
        properties.setProperty("proxy_host", "");
        properties.setProperty("use_proxy", "N");
        properties.setProperty("proxy_port", "");
        properties.setProperty("cert_count", "5");
        properties.setProperty("useHttp", "N");
        properties.setProperty("lang", "ru");
        properties.setProperty("tsa_URL", "http://tsp.pki.gov.kz");
        PropertyUtil.saveProperty();
    }

    public static int getPort() {
        return Integer.parseInt(PropertyUtil.getProperties().getProperty("port"));
    }

    public static int getCertCount() {
        int count = 5;
        try {
            count = Integer.parseInt(PropertyUtil.getProperties().getProperty("cert_count"));
        }
        catch (NumberFormatException e) {
            count = 5;
        }
        return count;
    }

    public static String getProxyPort() {
        return PropertyUtil.getProperties().getProperty("proxy_port");
    }

    public static String getProxyHost() {
        return PropertyUtil.getProperties().getProperty("proxy_host");
    }

    public static Boolean useProxy() {
        String useProxy = PropertyUtil.getProperties().getProperty("use_proxy");
        if (useProxy != null && YES.equalsIgnoreCase(useProxy)) {
            return true;
        }
        return false;
    }

    public static Boolean useAuth() {
        String useAuth = PropertyUtil.getProperties().getProperty("use_auth");
        if (useAuth != null && YES.equalsIgnoreCase(useAuth)) {
            return true;
        }
        return false;
    }

    public static Boolean useNTLM() {
        String useNTLM = PropertyUtil.getProperties().getProperty("use_ntlm");
        if (useNTLM != null && YES.equalsIgnoreCase(useNTLM)) {
            return true;
        }
        return false;
    }

    public static String getAuthLogin() {
        return PropertyUtil.getProperties().getProperty("auth_login");
    }

    public static String getAuthPassword() {
        return PropertyUtil.getProperties().getProperty("auth_pass");
    }

    public static boolean useHttp() {
        String useHttp = PropertyUtil.getProperties().getProperty("useHttp");
        return useHttp != null && YES.equalsIgnoreCase(useHttp);
    }

    public static String getAllowAdtrsses() {
        return PropertyUtil.getProperties().getProperty("allow_adresses");
    }

    public static List<String> getAllowOrigins() {
        return allowOrigins;
    }

    private static void setMaxFileSize() {
        maxFileSize = Long.parseLong((String)PropertyUtil.getProperties().get("max_file_size"));
        maxFileSize *= 0x100000L;
    }

    public static long getMaxFileSize() {
        return maxFileSize;
    }

    public static Properties getProperties() {
        return properties;
    }

    public static String get(String name) {
        return properties.getProperty(name);
    }

    public static String getUserDataDirectory() {
        return System.getProperty("user.home") + File.separator + ".NURSign" + File.separator + DIR_NAME;
    }

    private static void log(String message) {
        BundleLog.LOG.info(message);
    }

    private static void logError(String message) {
        BundleLog.LOG.error(message, null);
    }

    public static Boolean useFirstCertificate() {
        String useFirstCertificate = properties.getProperty("use_first_certificate");
        if (YES.equals(useFirstCertificate)) {
            return true;
        }
        return false;
    }
}

