/*
 * Decompiled with CFR 0.152.
 */
package kz.ecc.nursign.utils;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Set;
import kz.ecc.nursign.exceptions.NURSignException;
import kz.gov.pki.kalkan.util.encoders.Hex;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.utils.X509Util;
import kz.gov.pki.reference.KNCACertificateType;

public class SignUtil {
    public static String getCertType(X509Certificate certificate) throws CertificateParsingException, IOException, ProviderUtilException {
        Set types = X509Util.getKNCACertificateType((X509Certificate)certificate);
        StringBuilder sb = new StringBuilder();
        if (types.contains(KNCACertificateType.SIGNATURE)) {
            sb.append("S");
        }
        if (types.contains(KNCACertificateType.AUTHENTICATION)) {
            sb.append("A");
        }
        return sb.toString();
    }

    public static String getHash(byte[] data, String hashAlg) throws NURSignException {
        try {
            MessageDigest md = MessageDigest.getInstance(hashAlg);
            md.reset();
            md.update(data);
            return Hex.encodeStr((byte[])md.digest());
        }
        catch (Exception e) {
            throw new NURSignException(NURSignException.ExceptionTypes.GET_HASH_FAILED, e);
        }
    }
}

